clear all
close all
%% données et paramètres

m1 = 2500;
m2 = 320;
k1 = 80000;
k2 = 500000;
b1 = 350;
b2 = 15020;

%% Question 1 :Définition du Système Espace d'état avec 1 entrée

A=[0 1 0 0;(b1*b2 )/(m1*m2) 0 ( ( b1/m1)*( ( b1/m1) +(b1/m2) +(b2/m2)))-(k1 /m1) -(b1/m1);
b2/m2 0 -((b1/m1) +(b1/m2) +(b2/m2) ) 1;
k2 /m2 0 -((k1 /m1) +(k1 /m2) +(k2 /m2) ) 0 ] ;
B=[0 0;
1/m1 (b1*b2)/(m1*m2);
0 -(b2/m2);
(1/m1)+(1/m2) -(k2 /m2) ] ;
C=[0 0 1 0 ] ;
D=[0 0 ] ;
b=B(:,1)

sys2=ss(A,b,C,0);

%% Question 2 : Calcul de la fonction de transfert

Gsys2=tf(sys2);
zpk(Gsys2)
step(Gsys2)

%% Question 3 : propriétés et caractéristiques du système

%%% commandabilité

rank(ctrb(A,b))
%%% observabilité

rank(obsv(A,C))

%%% Stabilité asymptotique

eig(A)
%%% Caractérisation des modes
damp(sys2)

%%% stabilité BIBO

pole(Gsys2)

%% Question 5 : Retour d'état 
%%% Valeurs propres désirées:

Vp_desire=[-23.9732, -23.9732, -3/5 ,-5];




%%% Calcul du retour d'état
K=acker(A,b,Vp_desire);

%%% Systeme en boucle fermée avec sortie C=[0 0 1 0]
 
 sys_bf=ss(A-b*K,b,C,0)
%%% Réponse aux conditions initiales 
 figure
 initial(sys_bf, [0 ;0 ;0.1 ;0])
%%% Systeme en boucle fermée en visualisant les 4 états
 sys_bf_complet=ss(A-b*K,b,eye(4),0)
%%% Réponse aux conditions initiales
figure
 initial(sys_bf_complet, [0.1 ;0.1 ;0.1;0.1])
%%% Réponse à un échelon en entrée (peu réaliste)
figure
step(sys_bf)

%% Calcul de l'observateur
%%% Mise en forme du système
%%%%Matrice de permutation
P=[0 0 1 0;0 1 0 0;1 0 0 0;0 0 0 1];
%%%% définition du système dans la nouvelle base:
At=P*A*inv(P);
bt=P*b;
Ct=C*inv(P);
Dt=0
sys_t=ss(At,bt,Ct, Dt);
%%% définition du système avec comme sorties les 4 états
sys_t_simu=ss(At,bt,eye(4),0)
%%% Extraction des matrices
A11=At(1,1)
A12=At(1,2:4);
A21=At(2:4,1);
A22=At(2:4,2:4);
B1=bt(1);
B2=bt(2:4,1);
%%% définition de la dynamique de l'erreur 5* plus rapide et calcul des
%%% paramètres de l'observateur minimal
vp_desire_F=[-3 ;-10;-10];
vp_desire_F=[-6/5 ;-10;-10];
T1=(acker(A22',-A12',vp_desire_F))';
F=A22+T1*A12;
N=-T1;
M=eye(3);
T2=eye(3);
G=-F*T1+T1*A11+T2*A21
T=[T1 T2];
H=T*bt;
%%% définition de l'observateur

observateur=ss(F,[G H], M, [N zeros(3,1)]);
%%% Calcul du système en boucle fermée par RE basé observateur
Abf=[At-bt*K*P, -bt*K*P*[zeros(1,3);eye(3)];zeros(3,4) F];
Bbf=[bt;zeros(3,1)];
Cbf=[Ct zeros(1,3)];
Dbf=0;
systemeRE_OBS=ss(Abf,Bbf,Cbf,Dbf)
%%%%% réponse à des conditions initiales
figure
initial(systemeRE_OBS,[0.1 0 0 0 0 0 0])
%%%%% FT en boucle fermée
step(systemeRE_OBS)

%%%%% Systeme soumis � une perturbation.

Abf_pert=[At-bt*K*P, -bt*K*P*[zeros(1,3);eye(3)];zeros(3,4) F];
Bbf_pert=[bt;-T*bt];
Cbf_pert=[Ct zeros(1,3)];
Dbf_pert=0;

systemeRE_OBS_pert=ss(Abf_pert,Bbf_pert,Cbf_pert,Dbf_pert)
figure
bode(systemeRE_OBS_pert)



