clear all
close all

%% Donnes du problme

% Equation dynamique
A=[0 22 4;0 3 63;0 0 -5];
B=[2;0.5;1];

% Equation de la sortie tat x
xC=eye(3);
xD=zeros(3,1);
% Equation de la mesure y
yC=[1 0 0];
yD=[0];
% Equation de la sortie de performance z=y
zC=[1 0 0];
zD=[0];

Traces = 0;

%% Partie 1

% Q1 : vrification
eig(A)
xBOu = ss(A,B,xC,xD);
% Trac de la rponse  des CI
if(Traces)
	figure(1)
	initial(xBOu,[1;1;1],3);
	exportfig(1,'I1_reponseCI.png','height',20,'Width',28,'Format','png','Color','cmyk','Resolution',300,'FontMode','fixed','FontSize',15);
end

% Q2 : commandabilit et observabilit
Com = ctrb(A,B);
rank(Com)
Obs = obsv(A,yC);
rank(Obs)
yBOu = ss(A,B,yC,yD);
pole(tf(yBOu))

% Q3 : choix des valeurs propres de l'asservissement

Pdes = [-1.8 -5 -10];

% Q4 : calcul de K

K = acker(A,B,Pdes)
eig(A-B*K) % pour vrifier
yBFv = yC*feedback(xBOu,K)+yD;
Nprecomp = 1/dcgain(yBFv)
yBFyc = yBFv*Nprecomp;

% Q5 : simulation du retour d'tat

if(Traces)
	figure(2)
	step(yBFyc);
	exportfig(2,'I5_RE_sortie_y.png','height',20,'Width',28,'Format','png','Color','cmyk','Resolution',300,'FontMode','fixed','FontSize',15);
end
zero(yBFyc)

uBFv = feedback(1,K*xBOu)*Nprecomp;
if(Traces)
	figure(3)
	step(uBFv);
	exportfig(3,'I5_RE_sortie_u.png','height',20,'Width',28,'Format','png','Color','cmyk','Resolution',300,'FontMode','fixed','FontSize',15);
end

%% Partie 2

% Q1 : Prparation de l'observateur minimal identit

% Pas de changement de base ncessaire pour x car C est dj la premire
% ligne d'une identit

A11 = A(1,1);
A12 = A(1,2:3);
A21 = A(2:3,1);
A22 = A(2:3,2:3);
B1 = B(1);
B2 = B(2:3);

% Q2 : Rglage de l'observateur

PobsDes = [-2 -2];
G = acker(A22',A12',PobsDes)'
F = A22 - G*A12;
Gtilde = F*G + A21 - G*A11;
H = B2 - G*B1;
M = eye(2);
N = G;
eig(F)

% Q3 : Vrifications exprimentales

% Si on souhaite le tester sous Matlab seulement :
% x2Obsyu = ss(F,[Gtilde H],M,[N zeros(2,1)]);

%% Partie 3

% Q2 Amlioration de l'observateur

PobsDes = [-8 -8];
G = acker(A22',A12',PobsDes)'
F = A22 - G*A12;
Gtilde = F*G + A21 - G*A11;
H = B2 - G*B1;
M = eye(2);
N = G;
eig(F)

% Q3 Systme composite

Atotal = [A-B*K -B*K(1,2:3);zeros(2,3) F];
Btotal = [B*Nprecomp;zeros(2,1)];
Ctotal = [yC zeros(1,2)];
Dtotal = 0;

yBFTOTALyc = ss(Atotal,Btotal,Ctotal,Dtotal);
if(Traces)
    figure(4)
    step(yBFTOTALyc);
    exportfig(4,'III3_REOBS_step.png','height',20,'Width',28,'Format','png','Color','cmyk','Resolution',300,'FontMode','fixed','FontSize',15);
    figure(5)
    initial(yBFTOTALyc,[0;0;0;0.1;-0.1],5);
    exportfig(5,'III3_REOBS_initial.png','height',20,'Width',28,'Format','png','Color','cmyk','Resolution',300,'FontMode','fixed','FontSize',15);
end

% Q4 Observabilit et Commandabilit

Comtotal = ctrb(Atotal,Btotal);
rank(Comtotal)
Obstotal = obsv(Atotal,Ctotal);
rank(Obstotal)